<?php  
session_start();
include('connection.php');

// Initialize a message variable
$message = "";
$message_type = ""; // To store message type: success or danger

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['admin_username'];
    $password = $_POST['admin_password'];
    $fullname = $_POST['admin_fullname'];
    $gender = $_POST['admin_gender'];
    $role = $_POST['admin_role'];

    // Check if the username already exists
    $checkQuery = "SELECT * FROM admin WHERE admin_username = ?";
    $stmt = $con->prepare($checkQuery);
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $message = "Username already exists. Please choose a different username.";
        $message_type = "danger";
    } else {
        // Handle image upload
        if (isset($_FILES['admin_image']) && $_FILES['admin_image']['error'] == UPLOAD_ERR_OK) {
            $image_name = $_FILES['admin_image']['name'];
            $image_tmp = $_FILES['admin_image']['tmp_name'];
            $image_path = "uploads/" . basename($image_name); // Set your upload directory

            // Move the uploaded file to the specified directory
            if (move_uploaded_file($image_tmp, $image_path)) {
                // Insert data into the database
                $sql = "INSERT INTO admin (admin_username, admin_password, admin_fullname, admin_gender, admin_role, admin_image) 
                        VALUES (?, ?, ?, ?, ?, ?)";
                $stmt = $con->prepare($sql);
                $stmt->bind_param('ssssss', $username, $password, $fullname, $gender, $role, $image_path);

                if ($stmt->execute()) {
                    $message = "Admin registered successfully!";
                    $message_type = "success";
                } else {
                    $message = "Error registering admin. Please try again.";
                    $message_type = "danger";
                }
            } else {
                $message = "Failed to upload image.";
                $message_type = "danger";
            }
        } else {
            $message = "Image not uploaded or invalid.";
            $message_type = "danger";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Admin</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 70px;
        }
        .success-message {
            display: none;
            position: fixed;
            top: 70px; /* Adjusted to below the navbar */
            right: 20px;
            z-index: 1000;
            animation: slideIn 0.5s forwards;
            margin-top: 10px; /* Add a small margin */
        }
        @keyframes slideIn {
            from { transform: translateY(-100%); }
            to { transform: translateY(0); }
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top">
    <a class="navbar-brand" href="#">Admin Dashboard</a>
</nav>
<div class="container mt-5">
    <h2>Register Admin</h2>

    <!-- Display message if available -->
    <?php if ($message): ?>
        <div class='alert alert-<?php echo $message_type; ?> success-message'>
            <strong><?php echo $message; ?></strong> 
            <span class="tick" style="color: green; font-size: 20px;">&#10003;</span>
        </div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
        <div class="form-group">
            <label for="admin_username">Username</label>
            <input type="text" class="form-control" id="admin_username" name="admin_username" required>
        </div>
        
        <div class="form-group">
            <label for="admin_password">Password</label>
            <input type="password" class="form-control" id="admin_password" name="admin_password" required>
        </div>

        <div class="form-group">
            <label for="admin_fullname">Full Name</label>
            <input type="text" class="form-control" id="admin_fullname" name="admin_fullname" required>
        </div>

        <div class="form-group">
            <label for="admin_gender">Gender</label>
            <select name="admin_gender" id="admin_gender" class="form-control" required>
                <option value="">Select Gender</option>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
                <option value="Other">Other</option>
            </select>
        </div>

        <div class="form-group">
            <label for="admin_role">Role</label>
            <input type="text" class="form-control" id="admin_role" name="admin_role" required>
        </div>

        <div class="form-group">
            <label for="admin_image">Profile Image</label>
            <input type="file" class="form-control-file" id="admin_image" name="admin_image" accept="image/*" required>
        </div>

        <button type="submit" class="btn btn-primary">Register Admin</button>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
    $(document).ready(function() {
        // Show success message with tick on success
        $('.success-message').fadeIn().delay(3000).fadeOut();
    });
</script>
</body>
</html>
